<?php

include 'koneksi.php';
include 'header1.php';

// **Ambil data hasil perangkingan dari tabel hasil1**
$hasil_perhitungan = query("SELECT * FROM hasil1 ORDER BY nilai DESC");

// **Cek apakah ada nilai yang sama di peringkat teratas**
$nilai_tertinggi = $hasil_perhitungan[0]['nilai'];
$alternatif_tertinggi = array_filter($hasil_perhitungan, function ($row) use ($nilai_tertinggi) {
    return $row['nilai'] == $nilai_tertinggi;
});

?>

<div id="layoutSidenav_content">
    <main>
        <div class="container-fluid mt-5">
            <div class="card-header bg-primary text-white text-center mb-1">
                <h2 class="text-center flex-grow-1 " style="font-size: 28px; font-weight: bold;">
                <i class="fas fa-check"></i> RANKING RESULTS AND CONCLUSION</h2>
            </div>

            <br>

            <!-- **Check if calculation results are empty** -->
            <?php if (empty($hasil_perhitungan)) : ?>
                <div class="alert alert-danger text-center">
                    <strong>⚠️ No calculation results yet!</strong> Please perform the calculation process first on the SPK page.
                </div>
            <?php else : ?>

                <!-- **Display ranking results** -->
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered text-center w-100" style="font-size: 18px;">
                            <thead class="table-primary">
                                <tr>
                                    <th style="width: 10%;">Rank</th>
                                    <th style="width: 50%;">Alternative Name</th>
                                    <th style="width: 20%;">Final Score</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $rank = 1; ?>
                                <?php foreach ($hasil_perhitungan as $row) : ?>
                                    <tr <?= ($row['nilai'] == $nilai_tertinggi) ?>;>
                                        <td style="font-weight: bold;"><?= $rank++; ?></td>
                                        <td><?= htmlspecialchars($row['alternatif']); ?></td>
                                        <td style="font-weight: bold;"><?= number_format($row['nilai'], 6, '.', ''); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <br><br>

                <div class="text-center">
                    <a href="proses1.php" class="btn btn-lg btn-outline-primary">
                        <i class="fas fa-calculator"></i> View Calculation Process
                    </a>
                </div>

                <br><br>


               <!-- **Calculation Results Conclusion** -->
               <div class="card shadow-lg">
                    <div class="card-header bg-primary text-white text-center">
                        <h4><i class="fas fa-lightbulb"></i> Conclusion</h4>
                    </div>
                    <div class="card-body">
                        <?php if (count($alternatif_tertinggi) > 1) : ?>
                            <!-- 🔥 **If there is more than one alternative with the highest score** -->
                            <p class="text-justify" style="font-size: 18px;">
                                Based on the calculation results using the <b>Weighted Product</b> method, it was found that there are <b><?= count($alternatif_tertinggi); ?></b> alternatives with the same highest score.
                                This indicates that several alternatives or students have similar experiences in utilizing YouTube as an effective learning media.
                            </p>

                            <p class="text-justify" style="font-size: 18px;">
                                Below is the list of top alternatives with the highest ranking:
                            </p>

                            <ul style="font-size: 18px;">
                                <?php foreach ($alternatif_tertinggi as $alt) : ?>
                                    <li><b style="color: red;"><?= htmlspecialchars($alt['alternatif']); ?></b> with a final score of <b style="color: red;"><?= number_format($alt['nilai'], 6, '.', ''); ?></b></li>
                                <?php endforeach; ?>
                            </ul>

                            <p class="text-justify" style="font-size: 18px;">
                                The presence of more than one alternative with the highest score indicates that YouTube plays a significant role in enhancing the learning effectiveness of Informatics Engineering students.
                                Some key factors contributing to this effectiveness include content relevance, material delivery quality, audiovisual quality, interactivity and engagement, frequency of use, and minimal access barriers.
                            </p>

                            <p class="text-justify" style="font-size: 18px;">
                                From these results, it can be concluded that students tend to gain maximum benefits from YouTube-based learning sources that have systematic content, clear delivery, supportive visuals, and active engagement in the learning process.
                                Additionally, students who regularly use YouTube as a learning media tend to have a deeper understanding compared to those who use it sporadically.
                            </p>

                            <p class="text-justify" style="font-size: 18px;">
                                Therefore, the highest-ranking alternatives can serve as a primary reference for students and lecturers in selecting the most effective learning sources.
                                Educators can consider aspects that have been proven to support learning effectiveness and integrate them into formal teaching methods.
                                Meanwhile, students can use this ranking list as a guide in choosing YouTube channels that align with their academic needs to enhance their understanding of Informatics Engineering concepts more optimally.
                            </p>

                            <p class="text-justify" style="font-size: 18px;">
                                Additionally, YouTube can also be utilized by lecturers as an archive storage media for lectures or recorded learning sessions.
                                This provides greater flexibility in the teaching and learning process, allowing students to access materials anytime and anywhere.
                                With well-documented lecture recordings, students have the opportunity to review materials that they have not fully understood without time limitations.
                            </p>

                            <p class="text-justify" style="font-size: 18px;">
                                This flexibility makes YouTube an adaptive learning platform, enabling students to learn at their own pace and according to their individual learning styles.
                                Furthermore, lecturers can use YouTube as a media to compile more structured learning materials that can be used in the long term as valuable academic references.
                            </p>
                            <p class="text-justify" style="font-size: 18px;">
                                        Moreover, YouTube not only serves as a learning resource for students but also as a tool for lecturers in developing more effective teaching strategies.
                                        Lecture materials uploaded to YouTube can be used as a learning archive, allowing students to revisit the provided materials anytime according to their academic needs.
                                    </p>

                                    <p class="text-justify" style="font-size: 18px;">
                                        With the availability of learning documentation in video format, lecturers can analyze the teaching methods applied and evaluate their effectiveness.
                                        Thus, YouTube not only provides broader material accessibility for students but also supports the sustainable improvement of teaching quality in the academic environment.
                                    </p>


                                    <?php else : ?>
                            <!-- ✅ **If there is only one alternative with the highest score** -->
                            <p class="text-justify" style="font-size: 18px;">
                                Based on the calculation results using the <b>Weighted Product</b> method, the highest-ranked alternative is
                                <b style="color: red;">
                                    <?= htmlspecialchars($hasil_perhitungan[0]['alternatif']); ?></b>, with a final score of
                                <b style="color: red;">
                                    <?= number_format($hasil_perhitungan[0]['nilai'], 6, '.', ''); ?></b>.
                                This alternative has advantages over other alternatives in various aspects of learning evaluation.
                            </p>

                            <p class="text-justify" style="font-size: 18px;">
                                Based on ranking analysis, the main aspects contributing to the effectiveness of this best alternative include content relevance, quality of material delivery, audiovisual quality, interactivity and engagement, and frequency of use.
                                This alternative provides a more effective learning experience for Informatics Engineering students compared to other learning sources.
                            </p>

                            <p class="text-justify" style="font-size: 18px;">
                                Thus, this alternative can be recommended as the primary reference for evaluating the effectiveness of YouTube-based learning. The results can serve as a reference for students and educators in selecting the optimal learning sources to enhance their understanding of Informatics Engineering concepts more effectively.
                            </p>
                            <p class="text-justify" style="font-size: 18px;">
                                Additionally, YouTube can be utilized by lecturers as an archive storage media for lectures or recorded learning sessions.
                                This provides greater flexibility in the teaching-learning process, allowing students to access materials anytime and anywhere.
                                With well-documented lecture recordings, students have the opportunity to revisit materials they have not fully understood without time constraints.
                            </p>
                            <p class="text-justify" style="font-size: 18px;">
                                Furthermore, YouTube not only serves as a learning source for students but also as a tool for lecturers to develop more effective teaching strategies.
                                Lecture materials uploaded to YouTube can be used as learning archives, enabling students to review materials previously provided whenever needed for their academic purposes.
                            </p>

                            <p class="text-justify" style="font-size: 18px;">
                                Moreover, with learning documentation in video format, lecturers can analyze the teaching methods they have implemented and evaluate their effectiveness.
                                Thus, YouTube not only plays a role in providing broader material accessibility for students but also supports the continuous improvement of teaching quality in academic environments.
                            </p>

                        <?php endif; ?>
                    </div>
             

                        <br>

                <!-- **Export to PDF Form** -->
                <div class="text-center">
                    <p style="font-size: 18px;">⬇ *Download results in PDF format*</p>
                    <form action="reportpdf1.php" method="post">
                        <button type="submit" class="btn btn-lg btn-danger" name="submit">
                            <i class="fas fa-file-pdf"></i> Download PDF
                        </button>
                        <br><br>
                    </form>
                    
                </div>

            <?php endif; ?>
            </div>
        </div>
    </main>
</div>